{ -----------------------------------------------------------------------------
   sDesk 0.xxx - Semik's desktop, virtual desktops for MS-Windows
   Copyright (C) 1998  Jan Tomasek <xtomasej@fel.cvut.cz>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

History:
   31.10.1998 Released under GNU
              Added properties for NC like screen saver activation
------------------------------------------------------------------------------ }
unit Options;

interface

uses
  Windows,  Messages, SysUtils, Classes,
  Graphics, Controls, Forms,    Dialogs,
  StdCtrls, RXSpin,   ExtCtrls, Grids,
  ComCtrls, Menus,    Buttons,  Mask,
  ToolEdit, Config,   Sticky;

Const
  cAutoSwMode    = 5;
  cDeskPlus      = 8;
  cDeskMinus     = 9;
  cHideTask      =10;
  cShowTray      =11;

type
  TAutoSwMode = (asNone, asAutomatic, asKeyAck);
  TfOptions = class(TForm)
    MainOptPanel: TPanel;
    MainBtnPanel: TPanel;
    btnOk: TButton;
    btnCancel: TButton;
    MainPanel: TPanel;
    TableSet: TPageControl;
    General: TTabSheet;
    General_HideFromTaskBar: TCheckBox;
    General_PutIconToTry: TCheckBox;
    General_LContextMenuHotkey: TLabel;
    General_ContextMenuHotkey: THotKey;
    Window: TTabSheet;
    Window_DesktopDim: TGroupBox;
    Window_LCountX: TLabel;
    Window_LSizeX: TLabel;
    Window_LRow: TLabel;
    Window_LColumn: TLabel;
    Window_Column: TRxSpinEdit;
    Window_Row: TRxSpinEdit;
    Window_xStep: TRxSpinEdit;
    Window_yStep: TRxSpinEdit;
    Window_AllowAnyPosition: TRadioButton;
    Window_DockingPostion: TRadioButton;
    Window_Hiding_LVisiblePart: TLabel;
    Window_Hiding_not: TCheckBox;
    Window_Hiding_VisiblePart: TRxSpinEdit;
    Window_UseSmoothScrolling: TCheckBox;
    Window_Hiding: TGroupBox;
    Window_PositionHiding_Top: TSpeedButton;
    Window_PositionHiding_Bottom: TSpeedButton;
    Window_PositionHiding_Left: TSpeedButton;
    Window_PositionHiding_Right: TSpeedButton;
    ScreenSaver: TTabSheet;
    ScreenSaver_Time: TRxSpinEdit;
    ScreenSaver_LTime: TLabel;
    ScreenSaver_System: TRadioButton;
    ScreenSaver_RunCmd: TRadioButton;
    ScreenSaver_RunCmd_FileName: TFilenameEdit;
    ScreenSaver_LActivatePos: TLabel;
    ScreenSaver_LeftBottom: TSpeedButton;
    ScreenSaver_RightBottom: TSpeedButton;
    ScreenSaver_RightTop: TSpeedButton;
    ScreenSaver_LeftTop: TSpeedButton;
    ScreenSaver_Allowed: TCheckBox;
    ScreenSaver_LSensitivity: TLabel;
    ScreenSaver_Sensitivity: TRxSpinEdit;
    ScreenSaver_RunCmd_FileArgs: TEdit;
    ScreenSaver_RunCmd_LFileArgs: TLabel;
    ScreenSaver_AllowRerun: TCheckBox;
    Hotkeys: TTabSheet;
    Hotkeys_MainPanel: TPanel;
    Hotkeys_DeskPMPanel: TPanel;
    Hotkeys_LDeskPlus: TLabel;
    Hotkeys_LDeskMinus: TLabel;
    Hotkeys_DeskPlus: THotKey;
    Hotkeys_DeskMinus: THotKey;
    Hotkeys_Panel: TBevel;
    Hotkeys_DeskDirectPanel: TScrollBox;
    DeskSwitch: TTabSheet;
    DeskSwitch_PanelKey: TPanel;
    DeskSwitch_SWChngFocus: TGroupBox;
    DeskSwitch_SWChngFocus_Disabled: TRadioButton;
    DeskSwitch_SWChngFocus_Automatic: TRadioButton;
    DeskSwitch_SWChngFocus_AfterKey: TRadioButton;
    DeskSwitch_SWChngFocus_AfterKey_ALT: TRadioButton;
    DeskSwitch_SWChngFocus_AfterKey_SHIFT: TRadioButton;
    DeskSwitch_SWChngFocus_AfterKey_CTRL: TRadioButton;
    DeskSwitch_SwitchTo: TGroupBox;
    DeskSwitch_SwitchTo_Divided: TRadioButton;
    DeskSwitch_SwitchTo_BigMenu: TRadioButton;
    General_CycleDesktops: TCheckBox;
    Hotkeys_DeskPlusRow_L: TLabel;
    Hotkeys_DeskPlusRow: THotKey;
    Hotkeys_DeskMinusRow_L: TLabel;
    Hotkeys_DeskMinusRow: THotKey;
    General_MoveToFirst: TCheckBox;
    dlgColorBack: TColorDialog;
    Window_PagerTitle: TEdit;
    Window_ShowTitleBar: TCheckBox;
    Window_ShowDesktopNumbers: TCheckBox;
    Window_PagerBg: TLabel;
    Window_PagerBgColor: TPanel;
    Window_PagerFg: TLabel;
    dlgColorFore: TColorDialog;
    Window_PagerFgColor: TPanel;
    Window_PageGrid: TLabel;
    Window_PagerGridColor: TPanel;
    dlgColorGrid: TColorDialog;
    StickyWindows: TTabSheet;
    StickyWindows_StableList_L: TLabel;
    StickyWindows_StableList: TStringGrid;
    StickyWindows_StableAdd: TButton;
    StickyWindows_StableDelete: TButton;
    StickyWindows_Panel: TPanel;
    StickyWindows_Help: TMemo;
    StickyWindows_StableEdit: TButton;
    Hidden_App_Switches: TGroupBox;
    DeskSwitch_HideApps: TCheckBox;
    DeskSwitch_ResetApps: TCheckBox;
    General_CycleSingleRow: TRadioButton;
    General_CycleAllRows: TRadioButton;
    DesktopNames: TTabSheet;
    DesktopNames_Enabled: TCheckBox;
    DesktopNames_List: TStringGrid;
    DesktopName_Visible: TRxSpinEdit;
    DesktopName_VisibleL: TLabel;
    MouseSwitch: TGroupBox;
    MouseSwitch_Enabled: TCheckBox;
    MouseSwitch_SensitivityL: TLabel;
    MouseSwitch_Sensitivity: TRxSpinEdit;
    MouseSwitch_MoveCursor: TCheckBox;
    MouseSwitch_Speed: TRxSpinEdit;
    MouseSwitch_SpeedL: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure Window_PositionHiding_TopClick(Sender: TObject);
    procedure CheckState_Event(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Window_SelectColor(Sender: TObject);
    procedure StickyWindows_StableAddClick(Sender: TObject);
    procedure StickyWindows_StableEditClick(Sender: TObject);
    procedure StickyWindows_StableDeleteClick(Sender: TObject);
  private
    LabelA : Array[0..MaxDesktop-1] of TLabel;
    HotKA  : Array[0..MaxDesktop-1] of THotKey;
    FStickyWindows : TStickyWindows;
    FDesktopNames  : TStringList;
    { Private declarations }
    procedure ReallocHotkeys;
    procedure CheckState;
    function  GetDialogs:TsDeskCFG;
    function  GetDesktopCount:Integer;

    function  RData:TsDeskCFG;
    procedure WData(xData:TsDeskCFG);
    procedure DisplayStickyWindows;
    procedure DisplayDesktopNames;
    procedure ReadDesktopNames;
  public
    { Public declarations }
    property Data        : TsDeskCFG                      read RData     write WData;
  end;

var
  fOptions: TfOptions;

implementation

uses StickyProp;
{$R *.DFM}

{ **************************************************************************** }
{ * Property stuff                                                           * }
{ **************************************************************************** }
(*function  TfOptions.RDesk(I:Integer):TShortCut;
Begin
  Result:=0;
  If I>=GetDesktopCount Then Exit;
  Result:=HotKA [I].HotKey;
End;{-- RDesk -----------------------------------------------------------------}
procedure TfOptions.WDesk(I:Integer; V:TShortCut);
Begin
  If I>=GetDesktopCount Then Exit;
  HotKA [I].HotKey := V;
End;{-- WDesk -----------------------------------------------------------------}*)

procedure TfOptions.FormCreate(Sender: TObject);
Var
  I : Integer;
begin
  TableSet.ActivePage := General;

  Data := CFGdefault;

//  FDeskPlus.HotKey  := 41181{Shift + Alt + ['};
//  FDeskMinus.HotKey := 41179{Shift + Alt + ]'};
  For I:=0 To MaxDesktop-1 Do Begin
    LabelA[I] := nil;
    HotKA [I] := nil;
  End;
  // Direct desktop hotkeys
  ReallocHotKeys;

  FStickyWindows:=nil;
  StickyWindows_StableList.Cells[0, 0]:='Method';
  StickyWindows_StableList.Cells[1, 0]:='Parameters';
  StickyWindows_StableList.ColWidths[0] := Round(StickyWindows_StableList.Width*0.20);
  StickyWindows_StableList.ColWidths[1] := Round(StickyWindows_StableList.Width*(1-0.20))-5;

  FDesktopNames:=nil;
  DesktopNames_List.Cells[0, 0]  := 'Number';
  DesktopNames_List.Cells[1, 0]  := 'Name';
  DesktopNames_List.ColWidths[0] := Round(DesktopNames_List.Width*0.20);
  DesktopNames_List.ColWidths[1] := Round(DesktopNames_List.Width*(1-0.20))-5;
end;{-- FormCreate ------------------------------------------------------------}
procedure TfOptions.ReallocHotkeys;
Var
  I : Integer;
Begin
  // Allocate
  For I:=0 To Round(Window_Column.Value*Window_Row.Value-1) Do Begin
    If not Assigned(HotKA [I]) Then Begin //
      HotKA [I] := THotKey.Create(Hotkeys_DeskDirectPanel);
      HotKA [I].Parent      := Hotkeys_DeskDirectPanel;
      HotKA [I].Left        := Hotkeys_DeskPlus.Left+(I mod 2)*(Hotkeys_DeskMinus.Left-Hotkeys_DeskPlus.Left);
      HotKA [I].Top         := 5+22*(I div 2);
      HotKA [I].Width       := Hotkeys_DeskPlus.Width;
      HotKA [I].TabOrder    := 2+I;
      LabelA[I] := TLabel.Create(Hotkeys_DeskDirectPanel);
      LabelA[I].Parent      := Hotkeys_DeskDirectPanel;
      LabelA[I].FocusControl:= HotKA[I];
      LabelA[I].Left        := Hotkeys_LDeskPlus.Left+(I mod 2)*(Hotkeys_LDeskMinus.Left-Hotkeys_LDeskPlus.Left);
      LabelA[I].Top         := 5+Hotkeys_LDeskPlus.Top-Hotkeys_DeskPlus.Top+22*(I div 2);
      LabelA[I].Caption     := Format('Desk no %d', [I+1]);
    End
  End;

  // Delalocate
  For I:=Round(Window_Column.Value*Window_Row.Value) To MaxDesktop-1 Do Begin
    If Assigned(LabelA[I]) Then LabelA[I].Destroy;
    If Assigned(HotKA [I]) Then HotKA [I].Destroy;
    LabelA[I]:=nil;
    HotKA [I]:=nil;
  End;

  If FDesktopNames<>nil then begin
    For I:=FDesktopNames.Count To Round(Window_Column.Value*Window_Row.Value-1) do
      FDesktopNames.Add(Format('Desktop  %d', [I+1]));
    While Round(Window_Column.Value*Window_Row.Value)<FDesktopNames.Count do
      FDesktopNames.Delete(FDesktopNames.Count-1);
    DisplayDesktopNames;
  end;
End;

procedure TfOptions.btnOkClick(Sender: TObject);
begin
  ReadDesktopNames;
  ReallocHotkeys;
end;

procedure TfOptions.Window_PositionHiding_TopClick(Sender: TObject);
begin
  (Sender as TSpeedButton).Down := True;
end;
 
function  TfOptions.GetDesktopCount:Integer;
Begin
  Result:=Round(Window_Column.Value*Window_Row.Value);
End;

function  TfOptions.GetDialogs:TsDeskCFG;
function Window_GetDockingPos:TsDeskAlign;
Begin
  Result:=sDeskRIGHT;
  If Window_PositionHiding_Top.Down    Then Result:=sDeskTOP;
  If Window_PositionHiding_Bottom.Down Then Result:=sDeskBOTTOM;
  If Window_PositionHiding_Left.Down   Then Result:=sDeskLEFT;
  If Window_PositionHiding_Right.Down  Then Result:=sDeskRIGHT;
End;
function ScrennSaver_GetActivationPos:TsDeskSSaver;
Begin
  Result:=sDeskRIGHTTOP;
  If ScreenSaver_LeftTop.Down          Then Result:=sDeskLEFTTOP;
  If ScreenSaver_RightTop.Down         Then Result:=sDeskRIGHTTOP;
  If ScreenSaver_LeftBottom.Down       Then Result:=sDeskLEFTBOTTOM;
  If Screensaver_RightBottom.Down      Then Result:=sDeskRIGHTBOTTOM;
End;
function DesktopSwitch_GetMode:TsDeskSwitchMode;
Begin
  Result:=sDeskSwitchAUTO;
  If DeskSwitch_SWChngFocus_Disabled.Checked Then Result:=sDeskSwitchNONE;
  If DeskSwitch_SWChngFocus_AfterKey.Checked Then Result:=sDeskSwitchMANUAL;
End;
function DesktopSwitch_GetKey:TsDeskSwitchKey;
Begin
  Result:=sDeskSwitchALT;
  If DeskSwitch_SWChngFocus_AfterKey_SHIFT.Checked Then Result:=sDeskSwitchSHIFT;
  If DeskSwitch_SWChngFocus_AfterKey_CTRL.Checked Then Result:=sDeskSwitchCTRL;
End;
Var
  xData : TsDeskCFG;
  I     : Integer;
begin
  // Safe!!!
  xData := CFG;

  // General
  xData.General.HideFromTaskBar    := General_HideFromTaskBar.Checked;
  xData.General.PutIconToTray      := General_PutIconToTry.Checked;
  xData.General.ContextMenu        := General_ContextMenuHotkey.HotKey;
  xData.General.CycleDesktops      := General_CycleDesktops.Checked;
  { 19/07/99 added by Tim Boughen }
  xData.General.CycleSingleRow     := General_CycleSingleRow.Checked;
  { End Tim }
  xData.General.MoveToFirst        := General_MoveToFirst.Checked;
  // Hotkeys
  xData.HotKeys.DeskPlus           := Hotkeys_DeskPlus.HotKey;
  xData.HotKeys.DeskMinus          := Hotkeys_DeskMinus.HotKey;
  xData.HotKeys.DeskPlusRow        := Hotkeys_DeskPlusRow.HotKey;
  xData.HotKeys.DeskMinusRow       := Hotkeys_DeskMinusRow.HotKey;
  For I:=0 To GetDesktopCount-1 Do
  xData.HotKeys.DeskDirect[I]      := HotKA[I].HotKey;
  // Window
  xData.Window.Columns             := Round(Window_Column.Value);
  xData.Window.Rows                := Round(Window_Row.Value);
  xData.Window.xStep               := Round(Window_xStep.Value);
  xData.Window.yStep               := Round(Window_yStep.Value);
  xData.Window.NotHide             :=       Window_Hiding_not.Checked;
  xData.Window.Docking             :=       Window_DockingPostion.Checked;
  xData.Window.DockingPos          :=       Window_GetDockingPos;
  xData.Window.VisiblePart         := Round(Window_Hiding_VisiblePart.Value);
  xData.Window.SmoothHiding        :=       Window_UseSmoothScrolling.Checked;
  { 11.07.1999 Added by Tim Boughen }
  xData.Window.PagerTitle          :=       Window_PagerTitle.Text;
  xData.Window.ShowDesktopNumbers  :=       Window_ShowDesktopNumbers.Checked;
  xData.Window.ShowTitleBar        :=       Window_ShowTitleBar.Checked;
  xData.Window.ActiveColor         :=       Window_PagerFgColor.Color;
  xData.Window.InactiveColor       :=       Window_PagerBgColor.Color;
  xData.Window.GridColor           :=       Window_PagerGridColor.Color;
  { end Tim }
  // Screen saver
  xData.ScreenSaver.Allowed        :=       ScreenSaver_Allowed.Checked;
  xData.ScreenSaver.AllowRerun     :=       ScreenSaver_AllowRerun.Checked;
  xData.ScreenSaver.ActivationPos  :=       ScrennSaver_GetActivationPos;
  xData.ScreenSaver.ActivationTime := Round(ScreenSaver_Time.Value);
  xData.ScreenSaver.RunFile        :=       ScreenSaver_RunCmd.Checked;
  xData.ScreenSaver.RunFileName    :=       ScreenSaver_RunCmd_FileName.FileName;
  xData.ScreenSaver.RunFileArgs    :=       ScreenSaver_RunCmd_FileArgs.Text;
  xData.ScreenSaver.Sensitivity    := Round(ScreenSaver_Sensitivity.Value);
  // Desktop switching
  xData.DesktopSwitching.SwitchMode   := DesktopSwitch_GetMode;
  xData.DesktopSwitching.SwitchKey    := DesktopSwitch_GetKey;
  { 16.07.99 Added by Tim Boughen }
  xData.DesktopSwitching.HideApps     := DeskSwitch_HideApps.Checked;
  xData.DesktopSwitching.ResetApps    := DeskSwitch_ResetApps.Checked;
  { End Tim }
  xData.DesktopSwitching.MouseSwEnabled := MouseSwitch_Enabled.Checked;
  xData.DesktopSwitching.MouseSwSens    := MouseSwitch_Sensitivity.AsInteger;
  xData.DesktopSwitching.MouseSwSpeed   := MouseSwitch_Speed.AsInteger;
  xData.DesktopSwitching.MouseSwMoveCur := MouseSwitch_MoveCursor.Checked;

  // Desktop names
  ReadDesktopNames;
  xData.DesktopNames.Enabled          := DesktopNames_Enabled.Checked;
  xData.DesktopNames.Delay            := Round(DesktopName_Visible.Value);
  xData.DesktopNames.Names            := FDesktopNames;

  Result := xData;
end;

function  TfOptions.RData:TsDeskCFG;
begin
  Result := GetDialogs;
end;

procedure TfOptions.WData(xData:TsDeskCFG);
Var
  I: Integer;
begin
  // General
  General_HideFromTaskBar.Checked        := xData.General.HideFromTaskBar;
  General_PutIconToTry.Checked           := xData.General.PutIconToTray;
  General_ContextMenuHotkey.HotKey       := xData.General.ContextMenu;
  General_CycleDesktops.Checked          := xData.General.CycleDesktops;
  { 19/07/99 Added by Tim Boughen }
  General_CycleSingleRow.Checked         := xData.General.CycleSingleRow;
  { End Tim }
  General_MoveToFirst.Checked            := xData.General.MoveToFirst;
  // Window
  Window_Column.Value                    := xData.Window.Columns;
  Window_Row.Value                       := xData.Window.Rows;
  Window_xStep.Value                     := xData.Window.xStep;
  Window_yStep.Value                     := xData.Window.yStep;
  Window_Hiding_not.Checked              := xData.Window.NotHide;
  Window_DockingPostion.Checked          := xData.Window.Docking;
  Window_PositionHiding_Top.Down         := xData.Window.DockingPos=sDeskTOP;
  Window_PositionHiding_Bottom.Down      := xData.Window.DockingPos=sDeskBOTTOM;
  Window_PositionHiding_Left.Down        := xData.Window.DockingPos=sDeskLEFT;
  Window_PositionHiding_Right.Down       := xData.Window.DockingPos=sDeskRIGHT;
  Window_Hiding_VisiblePart.Value        := xData.Window.VisiblePart;
  Window_UseSmoothScrolling.Checked      := xData.Window.SmoothHiding;
  { 11.7.1999 Added by Tim Boughen }
  Window_PagerTitle.Text                 := xData.Window.PagerTitle;
  Window_ShowDesktopNumbers.Checked      := xData.Window.ShowDesktopNumbers;
  Window_ShowTitleBar.Checked            := xData.Window.ShowTitleBar;
  Window_PagerFgColor.Color              := xData.Window.ActiveColor;
  Window_PagerBgColor.Color              := xData.Window.InactiveColor;
  Window_PagerGridColor.Color            := xData.Window.GridColor;
  { end Tim }
  // HotKeys
  ReallocHotkeys;
  Hotkeys_DeskPlus.HotKey                := xData.HotKeys.DeskPlus;
  Hotkeys_DeskMinus.HotKey               := xData.HotKeys.DeskMinus;
  Hotkeys_DeskPlusRow.HotKey             := xData.HotKeys.DeskPlusRow;
  Hotkeys_DeskMinusRow.HotKey            := xData.HotKeys.DeskMinusRow;
  For I:=0 To GetDesktopCount-1 Do
  HotKA[I].HotKey                        := xData.HotKeys.DeskDirect[I];
  // Screen saver
  ScreenSaver_Allowed.Checked            := xData.ScreenSaver.Allowed;
  ScreenSaver_LeftTop.Down               := xData.ScreenSaver.ActivationPos=sDeskLEFTTOP;
  ScreenSaver_RightTop.Down              := xData.ScreenSaver.ActivationPos=sDeskRIGHTTOP;
  ScreenSaver_LeftBottom.Down            := xData.ScreenSaver.ActivationPos=sDeskLEFTBOTTOM;
  Screensaver_RightBottom.Down           := xData.ScreenSaver.ActivationPos=sDeskRIGHTBOTTOM;
  ScreenSaver_Time.Value                 := xData.ScreenSaver.ActivationTime;
  ScreenSaver_RunCmd.Checked             := xData.ScreenSaver.RunFile;
  ScreenSaver_RunCmd_FileName.FileName   := xData.ScreenSaver.RunFileName;
  ScreenSaver_RunCmd_FileArgs.Text       := xData.ScreenSaver.RunFileArgs;
  ScreenSaver_Sensitivity.Value          := xData.ScreenSaver.Sensitivity;
  // Desktop switching
  DeskSwitch_SWChngFocus_Disabled.Checked          := xData.DesktopSwitching.SwitchMode=sDeskSwitchNONE;
  DeskSwitch_SWChngFocus_Automatic.Checked         := xData.DesktopSwitching.SwitchMode=sDeskSwitchAUTO;
  DeskSwitch_SWChngFocus_AfterKey.Checked          := xData.DesktopSwitching.SwitchMode=sDeskSwitchMANUAL;
  DeskSwitch_SWChngFocus_AfterKey_ALT.Checked      := xData.DesktopSwitching.SwitchKey=sDeskSwitchALT;
  DeskSwitch_SWChngFocus_AfterKey_SHIFT.Checked    := xData.DesktopSwitching.SwitchKey=sDeskSwitchSHIFT;
  DeskSwitch_SWChngFocus_AfterKey_CTRL.Checked     := xData.DesktopSwitching.SwitchKey=sDeskSwitchCTRL;
  { 16.07.99 Added by Tim Boughen }
  DeskSwitch_HideApps.Checked                      := xData.DesktopSwitching.HideApps;
  DeskSwitch_ResetApps.Checked                     := xData.DesktopSwitching.ResetApps;
  { End Tim }
  MouseSwitch_Enabled.Checked                      := xData.DesktopSwitching.MouseSwEnabled;
  MouseSwitch_Sensitivity.Value                    := xData.DesktopSwitching.MouseSwSens;
  MouseSwitch_Speed.Value                          := xData.DesktopSwitching.MouseSwSpeed;
  MouseSwitch_MoveCursor.Checked                   := xData.DesktopSwitching.MouseSwMoveCur;
  // Sticky windows
  FStickyWindows                                   := xData.StickyWindows.List;
  // Desktop names
  DesktopNames_Enabled.Checked                     := xData.DesktopNames.Enabled;
  DesktopName_Visible.Value                        := xData.DesktopNames.Delay;
  FDesktopNames                                    := xData.DesktopNames.Names;
  DisplayDesktopNames;

  CheckState;
end;

procedure TfOptions.CheckState;
Begin
  // Screen saver
  ScreenSaver_System.Enabled                         := ScreenSaver_Allowed.Checked;
  ScreenSaver_RunCmd.Enabled                         := ScreenSaver_Allowed.Checked;
  ScreenSaver_RunCmd_FileName.Enabled                := ScreenSaver_Allowed.Checked;
  ScreenSaver_LTime.Enabled                          := ScreenSaver_Allowed.Checked;
  ScreenSaver_Time.Enabled                           := ScreenSaver_Allowed.Checked;
  ScreenSaver_LSensitivity.Enabled                   := ScreenSaver_Allowed.Checked;
  ScreenSaver_LActivatePos.Enabled                   := ScreenSaver_Allowed.Checked;
  ScreenSaver_LeftTop.Enabled                        := ScreenSaver_Allowed.Checked;
  ScreenSaver_LeftBottom.Enabled                     := ScreenSaver_Allowed.Checked;
  ScreenSaver_RightTop.Enabled                       := ScreenSaver_Allowed.Checked;
  ScreenSaver_RightBottom.Enabled                    := ScreenSaver_Allowed.Checked;
  ScreenSaver_AllowRerun.Enabled                     := ScreenSaver_Allowed.Checked;
  ScreenSaver_Sensitivity.Enabled                    := ScreenSaver_Allowed.Checked;
  // Screen saver: run system defined or file ...
  ScreenSaver_RunCmd_FileName.Enabled                := ScreenSaver_RunCmd.Checked and ScreenSaver_Allowed.Checked;
  ScreenSaver_RunCmd_FileArgs.Enabled                := ScreenSaver_RunCmd.Checked and ScreenSaver_Allowed.Checked;
  ScreenSaver_RunCmd_LFileArgs.Enabled               := ScreenSaver_RunCmd.Checked and ScreenSaver_Allowed.Checked;
  { 19/07/99 Added by Tim Boughen }
  // General
  General_CycleSingleRow.Enabled                     := General_CycleDesktops.Checked;
  General_CycleAllRows.Enabled                       := General_CycleDesktops.Checked;
  General_CycleAllRows.Checked                       := not General_CycleSingleRow.Checked;
  { End Tim }
  // Hiding
  Window_Hiding_not.Enabled                          := not Window_AllowAnyPosition.Checked;
  Window_Hiding_LVisiblePart.Enabled                 := not Window_AllowAnyPosition.Checked and not Window_Hiding_not.Checked;
  Window_Hiding_VisiblePart.Enabled                  := not Window_AllowAnyPosition.Checked and not Window_Hiding_not.Checked;
  // Hiding position
  Window_PositionHiding_Top.Enabled                  := Window_DockingPostion.Checked;
  Window_PositionHiding_Left.Enabled                 := Window_DockingPostion.Checked;
  Window_PositionHiding_Bottom.Enabled               := Window_DockingPostion.Checked;
  Window_PositionHiding_Right.Enabled                := Window_DockingPostion.Checked;
  // Desktop switching
  DeskSwitch_SWChngFocus_AfterKey_ALT.Enabled        := DeskSwitch_SWChngFocus_AfterKey.Checked;
  DeskSwitch_SWChngFocus_AfterKey_SHIFT.Enabled      := DeskSwitch_SWChngFocus_AfterKey.Checked;
  DeskSwitch_SWChngFocus_AfterKey_CTRL.Enabled       := DeskSwitch_SWChngFocus_AfterKey.Checked;
  DeskSwitch_ResetApps.Enabled                       := DeskSwitch_HideApps.Checked;
  MouseSwitch_Sensitivity.Enabled                    := MouseSwitch_Enabled.Checked;
  MouseSwitch_SensitivityL.Enabled                   := MouseSwitch_Enabled.Checked;
  MouseSwitch_Speed.Enabled                          := MouseSwitch_Enabled.Checked;
  MouseSwitch_SpeedL.Enabled                         := MouseSwitch_Enabled.Checked;
  MouseSwitch_MoveCursor.Enabled                     := MouseSwitch_Enabled.Checked;

  // Name of app/ caption of window
  Window_PagerTitle.ReadOnly                         := not CFG.Window.TitleChangeAllowed;
  If not CFG.Window.TitleChangeAllowed Then Window_PagerTitle.Color := clBtnFace;
  // Sticky windows
  If Assigned(FStickyWindows) Then Begin
    StickyWindows_StableEdit.Enabled                 := FStickyWindows.Count>0;
    StickyWindows_StableDelete.Enabled               := FStickyWindows.Count>0;
    DisplayStickyWindows;
  End;
  // Desktop names
  DesktopNames_List.Enabled                          := DesktopNames_Enabled.Checked;
  DesktopName_VisibleL.Enabled                       := DesktopNames_Enabled.Checked;
  DesktopName_Visible.Enabled                        := DesktopNames_Enabled.Checked;
End;

procedure TfOptions.CheckState_Event(Sender: TObject);
begin
  CheckState;
end;

procedure TfOptions.FormShow(Sender: TObject);
begin
  CheckState;
end;

procedure TfOptions.Window_SelectColor(Sender: TObject);
begin
  if dlgColorBack.Execute then (Sender as TPanel).Color := dlgColorBack.Color;
end;

function GetMode(SE: TStickyElement):String;
Begin
  Case SE.Mode of
    semHandle: Result:='w. handle';
    semClass : Result:='class name';
    semEXPR  : Result:='title';
    Else       Result:='???';
  End;
End;

function GetParams(SE: TStickyElement):String;
Begin
  Case SE.Mode of
    semHandle: Result:=IntToStr(SE.Handle);
    semClass : Result:=SE.EXEName;
    semEXPR  : Result:=SE.Expression;
    Else       Result:='???';
  End;
End;

Function Max(A,B:Integer):Integer;
Begin
  If A>B Then Result:=A Else Result:=B;
End;

procedure TfOptions.DisplayStickyWindows;
Var
  I,J : Integer;
Begin
  StickyWindows_StableList.RowCount:=Max(FStickyWindows.Count+1,2);
  J:=1; For I:=0 To FStickyWindows.Count-1 Do
    If FStickyWindows[I].Mode<>semHandle Then Begin
      StickyWindows_StableList.Cells[0,J]:=GetMode(FStickyWindows[I]);
      StickyWindows_StableList.Cells[1,J]:=GetParams(FStickyWindows[I]);
      StickyWindows_StableList.Cells[2,J]:=IntToStr(I);
      Inc(J);
    End;
  If J<2 Then Begin
    StickyWindows_StableList.RowCount:=2;
    StickyWindows_StableList.Cells[0,1]:='';
    StickyWindows_StableList.Cells[1,1]:='';
    StickyWindows_StableList.Cells[2,1]:='';
  End Else
    StickyWindows_StableList.RowCount:=J;
End;

procedure TfOptions.DisplayDesktopNames;
var
  I : Integer;
begin
  if not Assigned(FDesktopNames) then exit;

  DesktopNames_List.RowCount:=Max(FDesktopNames.Count+1,2);
  for I:=0 to FDesktopNames.Count-1 do begin
      DesktopNames_List.Cells[0,I+1] := IntToStr(I+1);
      DesktopNames_List.Cells[1,I+1] := FDesktopNames[I];
  end;
end;

procedure TfOptions.ReadDesktopNames;
var
  I : Integer;
begin
  if not Assigned(FDesktopNames) then exit;

  FDesktopNames.Clear;
  for I:=0 to DesktopNames_List.RowCount-1 do
    FDesktopNames.Add(DesktopNames_List.Cells[1,I+1]);
end;

procedure TfOptions.StickyWindows_StableAddClick(Sender: TObject);
Var
  SE: TStickyElement;
begin
  fStickyProp.Mode:=spmOptions;
  If fStickyProp.ShowModal=mrOk Then Begin
    SE:=TStickyElement.Create(-1, fStickyProp.ClassName, fStickyProp.PartOfTitle, fStickyProp.StickyMode);
    FStickyWindows.Add(SE);
    DisplayStickyWindows;
  End;
  CheckState;
end;

procedure TfOptions.StickyWindows_StableEditClick(Sender: TObject);
Var
  SE: TStickyElement;
begin
  SE:=FStickyWindows[StrToInt(StickyWindows_StableList.Cells[2,StickyWindows_StableList.Row])];
  If fStickyProp.ShowModal=mrOk Then Begin
    SE.Mode       := fStickyProp.StickyMode;
    SE.EXEName    := fStickyProp.ClassName;
    SE.Expression := fStickyProp.PartOfTitle;
    DisplayStickyWindows;
  End;
  CheckState;
end;

procedure TfOptions.StickyWindows_StableDeleteClick(Sender: TObject);
begin
  FStickyWindows.RemoveByIndex(StrToInt(StickyWindows_StableList.Cells[2,StickyWindows_StableList.Row]));
  DisplayStickyWindows;
  CheckState;
end;



end.
