unit StickyProp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Sticky;

type
  TfStickyPropMode = (spmContextMenu, spmOptions);
  TfStickyProp = class(TForm)
    bgHowToRecognize: TGroupBox;
    ByWindowHandle: TRadioButton;
    ByTitlePart: TRadioButton;
    ePartOfTitle: TEdit;
    ByClassName: TRadioButton;
    eClassName: TEdit;
    btnOk: TButton;
    btnCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure ByWindowHandleClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
    FMode : TfStickyPropMode;
    procedure Check;
    function RStickyMode:TStickyElementMode;
    procedure WStickyMode(SM:TStickyElementMode);
    function RWindClassName:String;
    procedure WWindClassName(EN:String);
    function RPartOfTitle:String;
    procedure WPartOfTitle(PT:String);
  public
    { Public declarations }
    property Mode: TfStickyPropMode read FMode write FMode;
    property StickyMode:TStickyElementMode read RStickyMode write WStickyMode;
    property WindClassName:String read RWindClassName write WWindClassName;
    property PartOfTitle:String read RPartOfTitle write WPartOfTitle;
  end;

var
  fStickyProp: TfStickyProp;

implementation
Uses
  Config;
{$R *.DFM}

function TfStickyProp.RStickyMode:TStickyElementMode;
Begin
  Result:=semEXPR;
  If ByWindowHandle.Checked Then Result:=semHandle;
  If ByClassName.Checked Then Result:=semClass;
End;

procedure TfStickyProp.WStickyMode(SM:TStickyElementMode);
Begin
  Case SM of
    semHandle: ByWindowHandle.Checked:=True;
    semClass : ByClassName.Checked:=True;
  Else         ByTitlePart.Checked:=True;
  End;
End;

function TfStickyProp.RWindClassName:String;
Begin
  Result:=eClassName.Text;
End;

procedure TfStickyProp.WWindClassName(EN:String);
Begin
  eClassName.Text:=EN;
End;

function TfStickyProp.RPartOfTitle:String;
Begin
  Result:=ePartOfTitle.Text;
End;

procedure TfStickyProp.WPartOfTitle(PT:String);
Begin
  ePartOfTitle.Text:=PT;
End;
         
procedure TfStickyProp.Check;
Begin
  ByWindowHandle.Enabled := Mode=spmContextMenu;

  ePartOfTitle.Enabled := ByTitlePart.Checked;

  If Mode=spmOptions Then Begin
    eClassName.Enabled := True;
    eClassName.Color   := clWindow;
  End Else Begin
    eClassName.Enabled := ByClassName.Checked;
    eClassName.Color   := clBtnFace;
  End;    
End;

procedure TfStickyProp.FormShow(Sender: TObject);
begin
  StickyMode := CFG.StickyWindows.LastMode;
  If StickyMode=semHandle Then StickyMode:=semEXPR;
  Check;
end;

procedure TfStickyProp.ByWindowHandleClick(Sender: TObject);
begin
  Check;
end;

procedure TfStickyProp.FormHide(Sender: TObject);
begin
  CFG.StickyWindows.LastMode := StickyMode;
end;

end.
