{ -----------------------------------------------------------------------------
  Mon DEFINE jsou:
     - SLOW ........... pomale vykreslovani konzole
     - DEBUGTERMDEF ... chvili pocka po kazde nezname esc sekvenci
     - DEBUGMSG ....... v programu je vlozen kod pro zapis chybovych hlasek
                        do souboru
------------------------------------------------------------------------------ }
Program SemTel_D;

uses
  STConfig in 'units\stconfig.pas',
  Classes,
  SysUtils,
  Forms,
  WinProcs,
  WinTypes,
  C3216 in 'units\units\C3216.pas',
  console in 'units\units\console.pas',
  Chronog in 'units\units\chronog.pas',
  Keygrab in 'units\units\keygrab.pas',
  MD4 in 'units\units\md4.pas',
  xFTPSrv in 'units\units\xFTPsrv.pas',
  xForms in 'units\units\xForms.pas',
  OTP in 'units\units\otp.pas',
  PanClock in 'units\units\PanClock.pas',
  RoundLed in 'units\units\RoundLED.pas',
  Ftpcli in 'units\fpiette\FTPcli.pas',
  FtpSrv in 'units\fpiette\FTPsrv.pas',
  FtpSrvC in 'units\fpiette\FTPsrvC.pas',
  MD5 in 'units\fpiette\Md5.pas',
  Wait in 'units\fpiette\wait.pas',
  WSockbuf in 'units\fpiette\wsockbuf.pas',
  WSocket in 'units\fpiette\wsocket.pas',
  SSLeay in 'units\SSLWSock\SSLeay.pas',
  SSLWSock in 'units\SSLWSock\SSLWSock.pas',
  LIBeay in 'units\SSLWSock\LIBeay.pas',
  NoLngF in 'units\NoLngF.pas' {fNoLngFile},
  SelectC in 'units\SelectC.pas' {fSelectConnection},
  MSGlib in 'units\msglib.pas',
  xTerm in 'units\xterm.pas',
  xTree in 'units\xtree.pas',
  AboutBox in 'units\forms\aboutbox.pas' {fAboutBox},
  ConnPar in 'units\forms\connpar.pas' {fConnectionParameters},
  InVis in 'units\forms\invis.pas' {fInvisible},
  OneLine in 'units\forms\oneline.pas' {fOneLineDlg},
  OTPCalc in 'units\forms\otpcalc.pas' {fOTPCalc},
  SelectIP in 'units\forms\SelectIP.pas' {fSelectIP},
  PromtKey in 'units\forms\PromtKey.pas' {fEditHotKey},
  Main in 'MAIN.pas' {fMain},
  SSLTnCnx in 'units\SSLWSock\SSLTnCnx.pas',
  pgpPKey in 'units\forms\pgpPKey.pas' {fPGPPublicKey},
  mime in 'units\units\mime.pas',
  Gauge95 in 'units\units\Gauge95.pas',
  kUnits in 'units\kUnits.pas',
  qConn in 'units\forms\qConn.pas' {fQuickConnect},
  SafeMem in 'units\units\SafeMem.pas',
  NetworkPrinterInDirectModeSelect in 'units\forms\NetworkPrinterInDirectModeSelect.pas' {fNetworkPrinterInDirectModeSelect};

{$IFDEF Win32}{$R SemTel.R32}{$ELSE}{$R SemTel.R16}{$ENDIF}

Var
  fMain  : TfMain;
begin
  {$IFDEF WIN32}Application.Initialize;{$ENDIF}

  {Load configure -------------------------------------------------------------}
  {$IFNDEF DEBUGMSG}STConfig.Init;{$ENDIF}{Allocate global data}
  If not IsMSGFile Then Begin {Without MSG file isn't posible continue}
    fNoLngFile:=TfNoLngFile.Create(Application);
    fNoLngFile.ShowModal;
    Application.Terminate;
    Exit;
  End;

  {Show splash screen ---------------------------------------------------------}
  fAboutBox            := TfAboutBox.Create(Application);
  fAboutBox.Show;
  fAboutBox.UpDate;

  Application.Title    := 'SemTel';
  {$IFDEF WIN32}Application.ShowMainForm := False;{$ENDIF}

  If LoadDialogs Then Begin
    AllocateDialog(_fOTPCalc             );
    AllocateDialog(_fOpenANSI            );
    AllocateDialog(_fEnterOneLineDlg     );
    AllocateDialog(_fSelectConnection    );
    AllocateDialog(_fPrinterSetupDialog  );
    AllocateDialog(_fConnectionParameters);
    AllocateDialog(_fEditHotKey          );
    AllocateDialog(_fSelectIP            );
    AllocateDialog(_fPGPPublicKey        );
    AllocateDialog(_fOrder               );
    AllocateDialog(_fQuickConnect        );
  End Else
    AllocateDialog(_fOTPCalc             );

  If SuperUser Then Begin
    fSelectConnection := TfSelectConnection.Create(Application);
    fSelectConnection.MSGFile := @STConfig.CFG^.MSG;
    fAboutBox.Free;
    fSelectConnection.ShowModal;
  End Else Begin
    Application.CreateForm(TfInvisible, fInvisible);
  Application.CreateForm(TfMain, fMain);
  fMain.MSGFile := @STConfig.CFG^.MSG;
    fMain.INIFile := @STConfig.CFG^.LocalINI;{}
    fMain.Show;
    WindowGenerateMenu;
    fAboutBox.Free;
  End;

  WindowHideMain;
  If CFG^.ConnectionName<>'' Then
    fMain.ConnectTo(CFG^.ConnectionName, '', '')
  Else
    If CFG^.ConnectionSelect Then fMain.ConnectionSelect;
  Application.Run;

  STConfig.Done; {Free config's memory}
  {$IFNDEF WIN32}
  SSLWSock.Done;
  {$ENDIF}
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuSemTel_DPR, 'main', 'End; -- SemTel shutdown >>>>>>>>>>');{$ENDIF}
end.
