{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version  : 0.885
Date     : 08.08.98
Dialog   : Invisible window
Function : For Delphi
             * Main from
           For me :
             * Showing invisible connection windows
             * Redirect focus to MainForm if has it set
History  : 30.4.98 QC
-------------------------------------------------------------------------------}
unit InVis;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages,
  Classes,  Graphics, Controls, Forms,
  Dialogs,  MSGlib,   Main;

type
  TfInvisible = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    {$IFNDEF WIN32}
    procedure OnApplicationMessage(var Msg: TMsg; var Handled: Boolean);{$ENDIF}
  public
    Rand       : Longint;
    RandUsed   : Boolean;
    FMainForm  : TfMain;
    { Public declarations }
    procedure FreeMainForm;
    procedure WndProc(var msg: TMessage); override;
    procedure OnException(Sender: TObject; E: Exception);
    property MainForm :TfMain   read FMainForm  write FMainForm;
  end;

var
  fInvisible: TfInvisible;

implementation
Uses
  STConfig, kUnits, C3216;
{$R *.DFM}

procedure TfInvisible.FormActivate(Sender: TObject);
begin
 if FMainForm<>nil Then PostMessage(FMainForm.Handle, WM_SETFOCUS, 0, 0);
end;

procedure TfInvisible.FormCreate(Sender: TObject);
begin
  Height                 := 0;
  Width                  := 0;
  RandUsed               := False;
  {$IFNDEF WIN32}
  Application.OnMessage  := OnApplicationMessage;{$ENDIF}
  Application.OnException:= OnException;
end;{-- FormCreate ------------------------------------------------------------}

{$IFNDEF WIN32}
procedure TfInvisible.OnApplicationMessage(var Msg: TMsg; var Handled: Boolean);
Var
  fMain : TfMain;
  I     : integer;
begin
  fMain := TfMain(WindowGetByHandle(GetActiveWindow));
  If (fMain=nil)or(FMainForm<>fMain) Then
    For I:=0 To CFG^.Windows.Count-1 Do
      If TfMain(CFG^.Windows.Items[I]).HasCaret Then
        PostMessage(TfMain(CFG^.Windows.Items[I]).Handle, WM_KILLFOCUS, 0, 0);
end;{$ENDIF}

procedure TfInvisible.FreeMainForm;
Var
  F : TForm;
begin
  F:=FMainForm;
  FMainForm:=nil;
  F.Free;
end;

procedure TfInvisible.WndProc(var msg: TMessage);
Begin
  Inc(Rand);
  Case msg.Msg of
    MSG_HIDEMAIN     : Begin
                         WindowHideMain;
                       End;
    MSG_GENERATEMENU : WindowGenerateMenu;
    MSG_KILLME       : Begin
                         CFG^.Windows.Remove(Pointer(msg.LParam));
                         TForm(msg.LParam).Free;
                         If CFG^.Windows.Count=0 Then Begin
                           PostMessage(Handle, MSG_CLOSE, 0, 0);
                           FMainForm:=nil;
                         End Else WindowGenerateMenu;
                       End;
    MSG_CLOSE        : Close;
  End;
  Inherited WndProc(msg);
End;

Var
  S : String;

procedure TfInvisible.OnException(Sender: TObject; E: Exception);
Begin
  S := 'V programu dolo k chyb. V ppad, e se tato chyba opakuje, podejte prosm zprvu autorovi. '+
       'Pvodn chybov hlen pedan systmem: "'+E.Message+'", tda vyjmky: "'+
       E.ClassName+'".'#0;
  Application.MessageBox(@S[1], 'SemTel - chyba', MB_ICONSTOP or MB_OK);
  {$IFDEF DEBUGMSG}WriteToLog(DebugNormal, kuInVis, 'OnException', E.ClassName+': '+E.Message);{$ENDIF}
End;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuInVis, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuInVis, 'finalization', '');{$ENDIF}{$ENDIF}
end.

