unit Chronog;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TChrono = class(TComponent)
  private
    { Private-declarations }
    Ftimestart:            TDateTime;
    Ftimestop:             TDateTime;
    FDelay:                TDateTime;
    FDelayInitial:         TDateTime;
    FDelayaver:            TdateTime;
    FDelaytotal:           TDateTime;
    FNumbermes:            Integer;
    Fifpause:              Boolean;
    Fifstart:              Boolean;
  protected
    { Protected-declarations }
    function getlast: Longint;
    function getaver: Longint;
    function gettotal: Longint;
  public
    { Public-declarations }
    constructor Create( Aowner: TComponent ); override;
    destructor Destroy; override;
    procedure start;
    procedure stop;
    procedure pause;
    procedure continue;
    procedure cancel;
    procedure raz;
    property last: Longint read getlast;
    property aver: Longint read getaver;
    property total: Longint read gettotal;
    property nb: Integer read Fnumbermes;

  published
    { Published-dclarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Custom', [TChrono]);
end;

constructor TChrono.create( Aowner: Tcomponent);
begin
  inherited Create( Aowner );
  Fifpause:= False;
  Fifstart:= False;
  FDelay:=0;
  FDelayInitial:=0;
  FDelayaver:=0;
  FDelaytotal:=0;
  FNumbermes:=0;
end;

destructor TChrono.destroy;
begin
  inherited Destroy;
end;

procedure TChrono.start;
begin
if Fifpause=false then
 begin
  if Fifstart=False then
   begin
        Fifstart:=true;
        Fifpause:=false;
        FTimestart:=Time;
        Fnumbermes:=Fnumbermes+1;
{        Fdelaytotal:=0;}
        Fdelayinitial:=0;
   end;
 end;
end;

procedure TChrono.stop;
begin
if Fifpause=false then
begin
 if Fifstart then
  begin
       Fifstart:=false;
       FTimestop:=Time;
       if FTimestop <= Ftimestart then Ftimestop:=Ftimestop+1;
       Fdelay:=FTimestop-FTimestart+Fdelayinitial;
       Fdelaytotal:=Fdelaytotal+Fdelay;
       Fdelayaver:=Fdelaytotal/Fnumbermes;
  end;
 end else
 begin
       Fifstart:=false;
       Fifpause:=false;
       Fdelaytotal:=Fdelaytotal+Fdelay;
       Fdelayaver:=Fdelaytotal/Fnumbermes;
 end;
end;

procedure Tchrono.cancel;
begin
if Fifstart then
 begin
 Fifstart:=false;
 Fifpause:=false;
 Fnumbermes:=Fnumbermes - 1;
 Fdelay:=0;
 end;
end;

procedure TChrono.pause;
begin
if Fifpause=false then
begin
 if Fifstart then
  begin
       FTimestop:=Time;
       Fifpause:=true;
       if FTimestop <= Ftimestart then Ftimestop:=Ftimestop+1;
       Fdelay:=FTimestop-FTimestart+Fdelayinitial;
 {      Fdelayinitial:=Fdelay}
  end;
 end;
end;

procedure TChrono.continue;
begin
if Fifpause then
begin
 if Fifstart then
  begin
  Fifpause:=false;
  Fdelayinitial:=Fdelay;
  Ftimestart:=Time;
  end;
 end;
end;

procedure TChrono.raz;
begin
  Fifpause:= False;
  Fifstart:= False;
  FDelay:=0;
  FDelayInitial:=0;
  FDelayaver:=0;
  FDelaytotal:=0;
  FNumbermes:=0;
end;

function Tchrono.getlast;
begin
Result:=round(FDelay*24*3600*1000);
end;

function Tchrono.getaver;
begin
Result:=round(FDelayaver*24*3600*1000);
end;

function Tchrono.gettotal;
begin
result:=round(Fdelaytotal*24*3600*1000);
end;

end.
